﻿using System;
using System.Data;
using System.Web.UI.WebControls;
using VeteransAffairs.Registries.Business.Utilities;

public partial class ReportUniqueIndividuals : BasePage
{
    bool batchReport = false;        

    protected void Page_Load(object sender, EventArgs e)
    {
        if (!AccessAllowed())
        {
            Response.Redirect("ErrorPage.aspx?id=100");
        }

        if (!IsPostBack)
        {
            Session["batchReport"] = SessionItemFactory.Create(batchReport.ToString());
            Session["EFRBatchPrintOptions"] = SessionItemFactory.Create(Helpers.getCrsSetting("EFRBatchPrintOptions"));
            Session["EFRIndividualPrintOptions"] = SessionItemFactory.Create(Helpers.getCrsSetting("EFRIndividualPrintOptions"));

            ClientScript.RegisterStartupScript(this.GetType(), "LoadPrintOptions", "window.onload=loadReportPrintOptions();");            

            //Session["ReportUniqueIndividuals.sortColumn"] = "CREATED";
            //Session["ReportUniqueIndividuals.sortOrder"] = "Descending";

            // Bind our data
            try
            {
                GridViewUniqueIndividualsFiles.DataSource = GetUniqueIndividualsFiles();
                GridViewUniqueIndividualsFiles.DataBind();
                GridViewUniqueIndividualsFiles.Caption = "Number of Unique Individuals Screened Report";
                GridViewUniqueIndividualsFiles.CaptionAlign = TableCaptionAlign.Top;
            }
            catch (Exception exc)
            {
                Logging.WriteLogToFile("Error in ReportUniqueIndividuals.PageLoad()", exc);
            }
        }
    }

    //protected void UniqueIndividuals_RowDataBound(object sender, GridViewRowEventArgs e)
    //{
    //}

    //public void UniqueIndividuals_RowCommand(object sender, GridViewCommandEventArgs e)
    //{
    //    if (e.CommandName == "Details")
    //    {
    //        int index = Convert.ToInt32(e.CommandArgument);
    //        GridViewUniqueIndividualsFiles.SelectedIndex = index;
    //        int id = Convert.ToInt32(GridViewUniqueIndividualsFiles.SelectedValue);

    //        UniqueIndividualsManager manager = new UniqueIndividualsManager();
    //        DOD_FRAGMENT_RAW_DATA file = manager.SelectByRawDataId(id);

    //        Response.ContentType = "application/x-unknown";
    //        Response.AppendHeader("Content-Disposition", "attachment; filename=\"" + file.ORIGINAL_NAME + "\"");
    //        Response.BinaryWrite((byte[])file.FILE_DATA.ToArray());
    //    }
    //}
    
    private bool AccessAllowed()
    {
        return true;
    }
    public override string TopMenuName()
    {
        return "Reporting";
    }

    public override string MenuItemName()
    {
        return "Referral Report";
    }

    public override string AppObjectCode()
    {
        return "EFR_UNIQUEINDIVIDUALS_REPORT";
    }

    public DataTable GetUniqueIndividualsFiles()
    {
        DataTable dataTable = new DataTable();

        try
        {
            dataTable = SqlProvider.ExecuteSPDataTable(
                "RegistryConnectionString",
                "dbo.usp_EFR_GetNumUniqueIndividuals",
                new object[] {
                    //Session["ReportUniqueIndividuals.sortColumn"].ToString(),
                    //Session["ReportUniqueIndividuals.sortOrder"].ToString(),
                    //TextBoxSearchCriteria.Text.Trim()
                 });
        }
        catch (Exception ex)
        {
            Logging.WriteLogToFile("Exception in GetUniqueIndividualsFiles()", ex);
        }

        return dataTable;
    }

    protected void UniqueIndividuals_SelectedIndexChanging(object sender, GridViewSelectEventArgs e)
    {

    }

    protected void UniqueIndividuals_PageIndexChanging(object sender, GridViewPageEventArgs e)
    {
        GridViewUniqueIndividualsFiles.DataSource = GetUniqueIndividualsFiles();
        GridViewUniqueIndividualsFiles.PageIndex = e.NewPageIndex;
        GridViewUniqueIndividualsFiles.DataBind();
    }

    //protected void GridViewUniqueIndividualsFiles_Sorting(object sender, GridViewSortEventArgs e)
    //{
    //    // Sort order is always Ascending ... deal with this
    //    if (Session["ReportUniqueIndividuals.sortColumn"].ToString() == e.SortExpression &&
    //        Session["ReportUniqueIndividuals.sortOrder"].ToString() == e.SortDirection.ToString())
    //    {
    //        if (Session["ReportUniqueIndividuals.sortOrder"].ToString() == "Ascending")
    //            Session["ReportUniqueIndividuals.sortOrder"] = "Descending";
    //        else
    //            Session["ReportUniqueIndividuals.sortOrder"] = "Ascending";
    //    }
    //    else
    //    {
    //        Session["ReportUniqueIndividuals.sortOrder"] = e.SortDirection;
    //        Session["ReportUniqueIndividuals.sortColumn"] = e.SortExpression;
    //    }

    //    GridViewUniqueIndividualsFiles.DataSource = GetUniqueIndividualsFiles();
    //    GridViewUniqueIndividualsFiles.PageIndex = 0;
    //    GridViewUniqueIndividualsFiles.DataBind();
    //}
}
